package com.bokesoft.yigo.meta.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import java.util.Spliterator;
import java.util.function.Consumer;

import com.bokesoft.yes.common.struct.StringLinkedHashMap;

public abstract class GenericKeyCollectionWithKey<T extends KeyPairMetaObject>
		extends KeyPairMetaObject implements Iterable<T> {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	protected StringLinkedHashMap<T> elementMap = null;

	public GenericKeyCollectionWithKey() {
		elementMap = new StringLinkedHashMap<T>();
	}

	public void add(T element) {
		synchronized(elementMap) {
			elementMap.put(element.getKey(), element);
		}
	}

	public void addAll(List<T> list) {
		for( T t : list ) {
			add(t);
		}
	}

	public int size() {
		synchronized(elementMap) {
			return elementMap.size();
		}
	}

	public void remove(String key) {
		synchronized(elementMap) {
			elementMap.remove(key);
		}
	}

	public void clear() {
		synchronized(elementMap) {
			elementMap.clear();
		}
	}

	public T get(String key) {
		synchronized(elementMap) {
			return elementMap.get(key);
		}
	}

	public Iterator<T> iterator() {
		synchronized(elementMap) {
			return elementMap.values().iterator();
		}
	}

	public Iterator<Entry<String, T>> entryIterator() {
		synchronized(elementMap) {
			return elementMap.entrySet().iterator();
		}
	}

	public boolean containsKey(String key){
		synchronized(elementMap) {
			return elementMap.containsKey(key);
		}
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}

	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc,
										   Object node, Object flag, int runType) throws MetaException {
		Iterator<Entry<String, T>> itEntry = elementMap.entrySet().iterator();
		Entry<String, T> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			T element = entry.getValue();
			if ( !element.isAutoGen() ) {
				Object childNode = env.prepare(element, node);
				element.traversal(env, doc, childNode, flag, runType);
			}
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public AbstractMetaObject clone() {
		GenericKeyCollectionWithKey<T> newObject = (GenericKeyCollectionWithKey<T>) newInstance();
		Iterator<Entry<String, T>> itEntry = elementMap.entrySet().iterator();
		Entry<String, T> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			newObject.add((T) entry.getValue().clone());
		}
		return newObject;
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public void forEach(Consumer<? super T> action) {
		synchronized(elementMap) {
			elementMap.values().forEach(action);
		}
	}

	/**
	 * 去掉@Override是为了兼容java7和java8
	 */
	public Spliterator<T> spliterator() {
		// TODO Auto-generated method stub
		return null;
	}

	public Collection<T> items() {
		return elementMap.values();
	}
}
