package com.bokesoft.yes.meta.persist.dom.xml.node;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;

public class TagNode extends AbstractNode {
	private String tagName = null;
	
	private Map<String, String> attributes = new LinkedHashMap<String, String>();
	private List<AbstractNode> nodes = new ArrayList<AbstractNode>();

	public TagNode() {
		super("");
	}

	public TagNode(String tagName) {
		super("");
		this.tagName = tagName;
	}

	public Map<String, String> getAttributes() {
		return this.attributes;
	}

	public void setAttributes(Map<String, String> attributes) {
		if (attributes != null) {
			this.attributes = attributes;
		}
	}
	
	public boolean hasAttribute(String attrName) {
		return attributes.containsKey(attrName);
	}

	public List<AbstractNode> getChildren() {
		return this.nodes;
	}

	public List<AbstractNode> getChildrenByTagName(String name) {
		List<AbstractNode> list = new ArrayList<AbstractNode>();
		List<AbstractNode> ch = getChildren();
		for (int i = 0; i < ch.size(); i++) {
			if ((ch.get(i) instanceof TagNode)
					|| (!((TagNode) ch.get(i)).getTagName().equals(name)))
				continue;
			list.add((TagNode) ch.get(i));
		}
		return list;
	}
	
	public TagNode findChildByTagNode(TagNode tagNode) {
		for(AbstractNode ch : nodes) {
			if (ch instanceof TagNode) {
				String curPrimaryKey = ((TagNode) ch).getPrimaryKey();
				String findPrimaryKey = tagNode.getPrimaryKey();
				if(curPrimaryKey.equalsIgnoreCase(findPrimaryKey)) {
					return (TagNode) ch;
				}
			}
		}
		return null;
	}
	
	public TagNode findFirstTagNodeByTagName(String tagName) {
		List<TagNode> list = findNodesByTagName(tagName);
		if (list == null || list.size() == 0) return null;
		return list.get(0);
	}
	
	public List<TagNode> findNodesByTagName(String tagName) {
		if (tagName == null) return null;
		List<TagNode> list = new ArrayList<TagNode>();
		loadNodesByTagName(tagName, list);
		return list;
	}
	
	public void loadNodesByTagName(String tagName, List<TagNode> list) {
		if (tagName == null) return;
		if (tagName.equals(this.getTagName())) {
			list.add(this);
			return;
		}
		
		for (AbstractNode ch : nodes) {
			if (ch instanceof TagNode) {
				((TagNode) ch).loadNodesByTagName(tagName, list);
			}
		}
	}

	public TagNode getFirst(String tag) {
		List<AbstractNode> tem = getChildrenByTagName(tag);
		if (tem.size() == 0) {
			return null;
		}
		return (TagNode) tem.get(0);
	}

	public TagNode getLast(String tag) {
		List<AbstractNode> tem = getChildrenByTagName(tag);
		if (tem.size() == 0) {
			return null;
		}
		return (TagNode) tem.get(tem.size() - 1);
	}

	public AbstractNode getFirst() {
		List<AbstractNode> list = getChildren();
		if (list.size() == 0) {
			return null;
		}
		return list.get(0);
	}

	public AbstractNode getLast() {
		List<AbstractNode> list = getChildren();
		if (list.size() == 0) {
			return null;
		}
		return list.get(list.size() - 1);
	}

	public TagNode addNode(AbstractNode node) {
/*		if (node instanceof TagNode) {
			if ("TextArea@memo".equalsIgnoreCase(((TagNode) node).getPrimaryKey()) ) {
				System.out.println();
			}
		}*/
		if (node == null) {
			throw new IllegalArgumentException("addNode:node cant null");
		}
		this.nodes.add(node);
		node.setParent(this);
		return this;
	}

	public TagNode setAttribute(String name, String value) {
		this.attributes.put(name, value);
		return this;
	}

	public String getTagName() {
		return this.tagName;
	}

	public TagNode setTagName(String tagName) {
		this.tagName = tagName;
		return this;
	}
	
	public String getPrimaryKey() {
		if (tagName == null) {
			return null;
		} 
		
		String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(tagName);
		String primaryValue = attributes.get(attrKey);
		primaryValue = (primaryValue == null ? "" : primaryValue);
		return tagName.concat("@").concat(primaryValue);
	}
	
	@Override
	public String toXml(int level) {
		StringBuilder strBuilder = new StringBuilder();
		if (level == 0) {
			strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
			appendPreComment(strBuilder, this, level);
		}
		appendLevelBlank(strBuilder, level);
		String sAttrs = getAttrsString();
		strBuilder.append("<").append(tagName);
		if (!StringUtil.isEmptyStr(sAttrs)) strBuilder.append(" ");
		strBuilder.append(sAttrs);
		
		if (nodes.size() > 0) {
			strBuilder.append(">").append("\r\n");
			for (AbstractNode node : nodes) {
				appendPreComment(strBuilder, node, level + 1);
	/*			if (node instanceof TextNode && 
						(node.getText() == null || node.getText().trim().length() == 0)) {
					continue;
				}*/
				strBuilder.append(node.toXml(level + 1)).append("\r\n");
				appendLastComment(strBuilder, node, level + 1);
			}
			appendLevelBlank(strBuilder, level);
			strBuilder.append("</").append(tagName).append(">");
		} else {
			strBuilder.append("/>");
		}
		
		if (level == 0) {
			strBuilder.append("\r\n");
			appendLastComment(strBuilder, this, level);
		}
		return strBuilder.toString();
	}
	
	private void appendPreComment(StringBuilder strBuilder, AbstractNode node, int level) {
		List<AbstractNode> listPreComment = node.getPreComment();
		if (listPreComment == null) {
			return;
		}
		for (AbstractNode comment : listPreComment) {
			strBuilder.append(comment.toXml(level)).append("\r\n");
		}
	}
	
	private void appendLastComment(StringBuilder strBuilder, AbstractNode node, int level) {
		List<AbstractNode> listLastComment = node.getLastComment();
		if (listLastComment == null) {
			return;
		}
		for (AbstractNode comment : listLastComment) {
			strBuilder.append(comment.toXml(level)).append("\r\n");
		}
	}
	
	private String getAttrsString() {
		String sAttrs = "";
		for(Map.Entry<String, String> entry : attributes.entrySet()) {
			if (sAttrs.length() == 0) {
				sAttrs = entry.getKey() + "=\"" + convertSpecialChars(entry.getValue()) + "\"";
			} else {
				sAttrs += " " + entry.getKey() + "=\"" + convertSpecialChars(entry.getValue()) + "\"";
			}
		}
		return sAttrs;
	}

	@Override
	public AbstractNode clone() {
		TagNode node = new TagNode(this.getTagName());
		for(Map.Entry<String, String> entry : getAttributes().entrySet()) {
			node.setAttribute(entry.getKey(), entry.getValue());
		}
		
		for (AbstractNode tmpNode : nodes) {
			node.getChildren().add(tmpNode.clone());
		}
		return node;
	}

	@Override
	public boolean hasPrimaryAttribute() {
		String primaryAttrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
		return !StringUtil.isBlankOrNull(attributes.get(primaryAttrKey));
	}
	
	public String getPrimaryAttrName() {
		return DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
	}
	
}
