package com.bokesoft.yes.meta.persist.dom.timer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.timer.action.TimerWorkitemCommit;

public class TimerWorkitemCommitAction extends
		BaseDomAction<TimerWorkitemCommit> {

	@Override
	public void load(Document document, Element element,
			TimerWorkitemCommit meta, int runType) {
		meta.setParticipatorFormula(DomHelper.readAttr(element,
				MetaConstants.TIMER_PARTCIPAOR_FORMULA, ""));
		meta.setResult(DomHelper.readAttr(element,
				MetaConstants.TIMER_RESULT, -1));
		meta.setUserInfo(DomHelper.readAttr(element,
				MetaConstants.TIMER_USER_INFO, ""));
	}

	@Override
	public void save(Document document, Element element,
			TimerWorkitemCommit meta, int runType) {
		DomHelper.writeAttr(element,
				MetaConstants.TIMER_PARTCIPAOR_FORMULA,
				meta.getParticipatorFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.TIMER_RESULT,
				meta.getResult(), -1);
		DomHelper.writeAttr(element, MetaConstants.TIMER_USER_INFO,
				meta.getUserInfo(), "");
	}

}
