package com.bokesoft.yes.meta.persist.dom.task.action.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TaskDataItemType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.task.data.MetaTaskDataItem;

public class MetaTaskDataItemAction extends BaseDomAction<MetaTaskDataItem> {

	@Override
	public void load(Document document, Element element, MetaTaskDataItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setType(TaskDataItemType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, TaskDataItemType.STR_REF)));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTaskDataItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(),"" );
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, TaskDataItemType.toString(meta.getType()), TaskDataItemType.STR_REF);
	}

}
