package com.bokesoft.yes.meta.persist.dom.strings;

import java.io.IOException;
import java.io.InputStream;

import com.bokesoft.yes.i18n.IStringMap;
import com.bokesoft.yes.i18n.XmlStringMapImpl;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

public class MetaStringTableReader {
	public static IStringMap load(IMetaFactory metaFactory, String project, String resource) {
		XmlStringMapImpl xmlMap = new XmlStringMapImpl();
		InputStream in = null;
		try {
			in = metaFactory.loadInputStream(project, resource);
			if ( in != null ) {
				xmlMap.load(in);
			}
		} catch ( Throwable e ) {
		} finally {
			if ( in != null ) {
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return xmlMap;
	}
	
	public static IStringMap load(InputStream in) {
		XmlStringMapImpl xmlMap = new XmlStringMapImpl();
		xmlMap.load(in);
		return xmlMap;
	}
}
