package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.app.MetaAppAction;
import com.bokesoft.yes.meta.persist.dom.app.MetaAppsAction;
import com.bokesoft.yes.meta.persist.dom.app.MetaRefProjectAction;
import com.bokesoft.yes.meta.persist.dom.calendar.MetaDayAction;
import com.bokesoft.yes.meta.persist.dom.calendar.MetaVacationAction;
import com.bokesoft.yes.meta.persist.dom.calendar.MetaWorkingCalendarAction;
import com.bokesoft.yes.meta.persist.dom.calendar.MetaWorkingCalendarCollectionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaInplaceToolbarAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaInplaceToolbarCollectionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaMidProcessAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaMidProcessFlowAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaMidProcessFlowCollectionAction;
import com.bokesoft.yigo.meta.app.MetaApp;
import com.bokesoft.yigo.meta.app.MetaApps;
import com.bokesoft.yigo.meta.app.MetaRefProject;
import com.bokesoft.yigo.meta.calendar.MetaDay;
import com.bokesoft.yigo.meta.calendar.MetaVacation;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendar;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendarCollection;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbar;
import com.bokesoft.yigo.meta.common.MetaInplaceToolbarCollection;
import com.bokesoft.yigo.meta.common.MetaMidProcess;
import com.bokesoft.yigo.meta.common.MetaMidProcessFlow;
import com.bokesoft.yigo.meta.common.MetaMidProcessFlowCollection;
import com.bokesoft.yigo.meta.solution.MetaBPMSetting;
import com.bokesoft.yigo.meta.solution.MetaClientBPMAction;
import com.bokesoft.yigo.meta.solution.MetaLang;
import com.bokesoft.yigo.meta.solution.MetaLangConfig;
import com.bokesoft.yigo.meta.solution.MetaPreLoadItem;
import com.bokesoft.yigo.meta.solution.MetaPreLoadItemCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectCollection;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;
import com.bokesoft.yigo.meta.solution.MetaScheduleJob;
import com.bokesoft.yigo.meta.solution.MetaScheduleJobCollection;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.solution.MetaStartItem;
import com.bokesoft.yigo.meta.solution.MetaStartItemCollection;
import com.bokesoft.yigo.meta.solution.MetaTrigger;

public class MetaSolutionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
			{ MetaSolution.TAG_NAME, new MetaSolutionAction() },
			{ MetaProjectCollection.TAG_NAME,
					new MetaProjectCollectionAction() },
			{ MetaProjectProfile.TAG_NAME, new MetaProjectProfileAction() },
			{ MetaInplaceToolbarCollection.TAG_NAME,
					new MetaInplaceToolbarCollectionAction() },
			{ MetaInplaceToolbar.TAG_NAME, new MetaInplaceToolbarAction() },
			{ MetaMidProcessFlowCollection.TAG_NAME,
					new MetaMidProcessFlowCollectionAction() },
			{ MetaMidProcessFlow.TAG_NAME, new MetaMidProcessFlowAction() },
			{ MetaMidProcess.TAG_NAME, new MetaMidProcessAction() },
			{ MetaDay.TAG, new MetaDayAction() },
			{ MetaVacation.TAG, new MetaVacationAction() },
			{ MetaWorkingCalendar.TAG, new MetaWorkingCalendarAction() },
			{ MetaWorkingCalendarCollection.TAG,
					new MetaWorkingCalendarCollectionAction() },
			{ MetaBPMSetting.TAG_NAME, new MetaBPMSettingAction() },
			{ MetaClientBPMAction.TAG_NAME, new MetaClientBPMActionAction() },
			
			{ MetaStartItemCollection.TAG_NAME, new MetaStartItemCollectionAction() },
			{ MetaStartItem.TAG_NAME, new MetaStartItemAction() },
			
			{ MetaPreLoadItemCollection.TAG_NAME,new MetaPreLoadItemCollectionAction()},
			{ MetaPreLoadItem.TAG_NAME,new MetaPreLoadItemAction()},
			
			{ MetaLangConfig.TAG_NAME,new MetaLangConfigAction()},
			{ MetaLang.TAG_NAME,new MetaLangAction()},
			
			{ MetaScheduleJobCollection.TAG_NAME,new MetaScheduleJobCollectionAction()},
			{ MetaScheduleJob.TAG_NAME,new MetaScheduleJobAction()},
			{ MetaTrigger.TAG_NAME, new MetaTriggerAction()},
			{ MetaApp.TAG_NAME, new MetaAppAction() },
			{ MetaApps.TAG_NAME, new MetaAppsAction() },
			{ MetaRefProject.TAG_NAME, new MetaRefProjectAction() }
		};
	}

	/** 应用事件映射单体实例 */
	private static MetaSolutionMap instance = null;
	
	public static MetaSolutionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaSolutionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
