package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.MetaReportGridColumn;
import com.bokesoft.yigo.meta.report.ReportColumnType;

public class MetaReportGridColumnAction extends BaseDomAction<MetaReportGridColumn> {

	@Override
	public void load(Document document, Element element,
			MetaReportGridColumn meta, int runType) {
		meta.setType(ReportColumnType.parse(DomHelper.readAttr(element, MetaReportConstants.COLUMN_TYPE, ReportColumnType.STR_Fix)));
		meta.setWidth(DomHelper.readAttr(element, MetaReportConstants.COLUMN_WIDTH, 0));
		meta.setVisible(DomHelper.readAttr(element, MetaReportConstants.COLUMN_VISIBLE, ""));
		meta.setExpandKey(DomHelper.readAttr(element, MetaReportConstants.COLUMN_EXPAND_KEY, ""));
		meta.setLock(DomHelper.readAttr(element, MetaReportConstants.COLUMN_LOCK, false));
		meta.setNeedDetermineRowWrap(DomHelper.readAttr(element, MetaReportConstants.COLUMN_NEEDDETERMINEROWWRAP, false));
	}

	@Override
	public void save(Document document, Element element,
			MetaReportGridColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_TYPE, ReportColumnType.toString(meta.getType()), ReportColumnType.STR_Fix);
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_WIDTH, meta.getWidth(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_EXPAND_KEY, meta.getExpandKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_LOCK, meta.isLock(), false);
		DomHelper.writeAttr(element, MetaReportConstants.COLUMN_NEEDDETERMINEROWWRAP, meta.isNeedDetermineRowWrap(), false);
	}

}
