package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FullscreenType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;

public class MetaMobileDefAction extends BaseDomAction<MetaMobileDef>{

	@Override
	public void load(Document document, Element element, MetaMobileDef meta, int runType) {
		meta.setCss(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_CSS, ""));
		meta.setHasNavigationBar(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_HASNAVIGATIONBAR, ""));
		meta.setVersionPath(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_VERSIONPATH, ""));
		meta.setSysLanguage(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_SYSLANGUAGE, true));
		meta.setPassErrorCount(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_PASSERRORCOUNT, 0));
		meta.setPassEnableTime(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_PASSENABLETIME, 60));
		meta.setServerVersion(DomHelper.readAttr(element, MetaConstants.MOBILEDEF_SERVERVERSION, null));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.MOBILEDEF_DISABLEKEYBOARD, null));
		
		meta.setRequiredIcon(DomHelper.readAttr(element, MetaConstants.COMMON_REQUIRED_ICON, ""));
		meta.setCheckRulePassIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_PASS_ICON, ""));
		meta.setCheckRuleErrorIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_ERROR_ICON, ""));
		String fullScreenType = DomHelper.readAttr(element, MetaConstants.FORM_FULLSCREENTYPE, null);
		if(fullScreenType != null){
			meta.setFullscreenType(FullscreenType.parse(fullScreenType));
		}
		meta.setStatusBarColor(DomHelper.readAttr(element, MetaConstants.FORM_STATUSBAR_COLOR, null));
	}

	@Override
	public void save(Document document, Element element, MetaMobileDef meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_CSS, meta.getCss(), "");
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_HASNAVIGATIONBAR, meta.getHasNavigationBar(), "");
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_VERSIONPATH, meta.getVersionPath(), "");
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_SYSLANGUAGE, meta.isSysLanguage(), true);
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_PASSENABLETIME, meta.getPassEnableTime(), 60);
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_PASSERRORCOUNT, meta.getPassErrorCount(), 0);
		DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_SERVERVERSION, meta.getServerVersion(), null);
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.MOBILEDEF_DISABLEKEYBOARD, meta.isDisableKeyboard(), false);
		}
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_REQUIRED_ICON, meta.getRequiredIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECKRULE_PASS_ICON, meta.getCheckRulePassIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECKRULE_ERROR_ICON, meta.getCheckRuleErrorIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_FULLSCREENTYPE, FullscreenType.format(meta.getFullscreenType()), "");
		DomHelper.writeAttr(element, MetaConstants.FORM_STATUSBAR_COLOR, meta.getStatusBarColor(), null);
	}
}
