package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.view.layout.MetaComponentLayoutAction;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;

public class MetaSplitLayoutAction extends MetaComponentLayoutAction {
	@Override
	public void load(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.load(document, element, meta, runType);
		MetaSplitLayout metaSplitLayout = (MetaSplitLayout)meta;
		int orientation = OrientationType.parse(DomHelper
				.readAttr(element, MetaConstants.COMPONENT_ORIENTATION,
						OrientationType.STR_Horizontal));
		metaSplitLayout.setOrientation(orientation);
	}

	@Override
	public void save(Document document, Element element,
			AbstractMetaObject meta, int runType) {
		super.save(document, element, meta, runType);
		MetaSplitLayout metaSplitLayout = (MetaSplitLayout)meta;
		DomHelper.writeAttr(element,
				MetaConstants.COMPONENT_ORIENTATION,
				OrientationType.toString(metaSplitLayout.getOrientation()), OrientationType.STR_Horizontal);
	}
}
