package com.bokesoft.yes.meta.persist.dom.form.component.view;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.view.overrides.MetaBaseComponentOverrides;

public class MetaBaseComponentOverridesAction extends BaseDomAction<MetaBaseComponentOverrides> {

	@Override
	public void load(Document document, Element element, MetaBaseComponentOverrides meta, int runType) {
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setForeColor(DomHelper.readAttr(element, MetaConstants.COMMON_FORECOLOR, ""));
		meta.setFontSize(DomHelper.readAttr(element, "FontSize", 12));
	}

	@Override
	public void save(Document document, Element element, MetaBaseComponentOverrides meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORECOLOR, meta.getForeColor(), "");
		DomHelper.writeAttr(element, "FontSize", meta.getFontSize(), 12);
	}
}
