package com.bokesoft.yes.meta.persist.dom.form.component.panel.tablepanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.panel.MetaPanelAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaFluidTableLayoutPanel;

public class MetaFluidTableLayoutPanelAction extends MetaPanelAction<MetaFluidTableLayoutPanel> {
	@Override
	public void load(Document document, Element element, MetaFluidTableLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setRepeatCount(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATCOUNT, 1));
		meta.setRepeatGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATGAP, 0));
		meta.setRowGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWGAP, 0));
		meta.setColumnGap(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_COLUMNGAP, 0));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWHEIGHT, 20));
	}

	@Override
	public void save(Document document, Element element, MetaFluidTableLayoutPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATCOUNT, meta.getRepeatCount(), 1);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_REPEATGAP, meta.getRepeatGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWGAP, meta.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_COLUMNGAP, meta.getColumnGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLUIDTABLELAYOUT_ROWHEIGHT, meta.getRowHeight(), 20);
	}
}
