package com.bokesoft.yes.meta.persist.dom.form.component.panel.gridpanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;

public class MetaRowDefAction extends BaseDomAction<MetaRowDef> {
	@Override
	public void load(Document document, Element element, MetaRowDef meta,
			int runType) {
		String height = DomHelper.readAttr(element,
				MetaConstants.COMMON_HEIGHT, "");
		if (height != null && !height.isEmpty()) {
			meta.setHeight(DefSize.parse(height));
		} else {
			meta.setHeight(new DefSize(-1, 0));
		}
	}

	@Override
	public void save(Document document, Element element, MetaRowDef meta,
			int runType) {
		DefSize height = meta.getHeight();
		if (height != null) {
			DomHelper.writeAttr(element,
					MetaConstants.COMMON_HEIGHT, height.toString(),  "");
		}
	}
}
