package com.bokesoft.yes.meta.persist.dom.form.component.panel.flexgridpanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.panel.MetaPanelAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.flexgridpanel.MetaFlexGridLayoutPanel;

public class MetaFlexGridLayoutPanelAction extends MetaPanelAction<MetaFlexGridLayoutPanel>{
	@Override
	public void load(Document document, Element element, MetaFlexGridLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setColumnCount(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNCOUNT, 1));
		meta.setRowGap(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWGAP, 0));
		meta.setColumnGap(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNGAP, 0));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWHEIGHT, 30));
	}

	@Override
	public void save(Document document, Element element, MetaFlexGridLayoutPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNCOUNT, meta.getColumnCount(), 1);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWGAP, meta.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_COLUMNGAP, meta.getColumnGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.FLEXGRIDLAYOUT_ROWHEIGHT, meta.getRowHeight(), 30);
	}
}
