package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.SlidingPosition;
import com.bokesoft.yigo.common.def.SlidingType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;

public class MetaSlidingLayoutPanelAction extends MetaComponentAction<MetaSlidingLayoutPanel> {
	@Override
	public void load(Document document, Element element, MetaSlidingLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStyle(SlidingType.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_STYLE, SlidingType.STR_DRAWER)));
		meta.setSlidingPosition(SlidingPosition.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_POSITION, SlidingPosition.STR_LEFT)));
		meta.setLeftWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_LEFTWIDTH, "200px")));
		meta.setRightWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_RIGHTWIDTH, "200px")));
	}

	@Override
	public void save(Document document, Element element, MetaSlidingLayoutPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.SLIDING_STYLE, SlidingType.toString(meta.getStyle()), SlidingType.STR_DRAWER);
		DomHelper.writeAttr(element, MetaConstants.SLIDING_POSITION, SlidingPosition.toString(meta.getSlidingPosition()), SlidingPosition.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.SLIDING_LEFTWIDTH, meta.getLeftWidth() == null ? "" : meta.getLeftWidth().toString(), "");
		DomHelper.writeAttr(element, MetaConstants.SLIDING_RIGHTWIDTH, meta.getRightWidth() == null ? "" : meta.getRightWidth().toString(), "");
	}
}
