package com.bokesoft.yes.meta.persist.dom.form.component.html;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.html.MetaHtmlElement;

/**
 * 基础Html元素对象在保存和载入时的相关动作
 * 
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaHtmlElementAction<T extends MetaHtmlElement> extends MetaComponentAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setID(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ID, ""));
		meta.setText(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_TEXT, ""));
		meta.setHidden(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_HIDDEN, false));
		meta.setKeyDownEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONKEYDOWN, ""));
		meta.setKeyUpEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONKEYUP, ""));
		meta.setKeyPressEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONKEYPRESS, ""));
		meta.setOnClickEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONCLICK, ""));
		meta.setOnDblClickEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONDBLCLICK, ""));
		meta.setOnMouseDownEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEDOWN, ""));
		meta.setOnMouseUpEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEUP, ""));
		meta.setOnMouseOverEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEOVER, ""));
		meta.setOnMouseOutEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEOUT, ""));
		meta.setOnMouseMoveEvent(DomHelper.readAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEMOVE, ""));
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ID, meta.getID(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_TEXT, meta.getText(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_HIDDEN, meta.isHidden(), false);
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONKEYDOWN, meta.getKeyDownEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONKEYUP, meta.getKeyUpEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONKEYPRESS, meta.getKeyPressEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONCLICK, meta.getOnClickEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONDBLCLICK, meta.getOnDblClickEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEDOWN, meta.getOnMouseDownEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEUP, meta.getOnMouseUpEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEOVER, meta.getOnMouseOverEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEOUT, meta.getOnMouseOutEvent(), "");
		DomHelper.writeAttr(element, MetaConstants.HTMLELEMENT_ONMOUSEMOVE, meta.getOnMouseMoveEvent(), "");
	}
}
