package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.RowType;
import com.bokesoft.yigo.common.def.SubDetailLinkType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;

public class MetaGridRowAction extends BaseDomAction<MetaGridRow> {
	@Override
	public void load(Document document, Element element, MetaGridRow meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setRowType(RowType.parse(DomHelper.readAttr(element, MetaConstants.ROW_TYPE, RowType.STR_Detail)));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.ROW_HEIGHT, MetaGridRow.DEFAULT_HEIGHT));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.GROUP_KEY, ""));
		meta.setDetailKey(DomHelper.readAttr(element, MetaConstants.DETAIL_KEY, ""));
		meta.setDefaultLayer(DomHelper.readAttr(element, MetaConstants.ROW_DEFAULTLAYER, -1));
		meta.setLinkType(SubDetailLinkType.parse(DomHelper.readAttr(element, MetaConstants.LINK_TYPE, SubDetailLinkType.STR_Parent)));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.SOURCE_FIELDS, ""));
		meta.setTarget(DomHelper.readAttr(element, MetaConstants.TARGET_FIELDS, ""));
		meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setFrozen(DomHelper.readAttr(element, MetaConstants.COMMON_FREEZE, false));
		meta.setKeywords(DomHelper.readAttr(element, MetaConstants.COMMON_KEYWORDS, ""));
		meta.setRefKey(DomHelper.readAttr(element, MetaConstants.COMMON_REFKEY, ""));
        meta.setRowTreeImg(DomHelper.readAttr(element, MetaConstants.COMMON_ROWTREEIMG, ""));
	}

	@Override
	public void save(Document document, Element element, MetaGridRow meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.ROW_TYPE, RowType.toString(meta.getRowType()), RowType.STR_Detail);		
		DomHelper.writeAttr(element, MetaConstants.ROW_HEIGHT, meta.getRowHeight(), MetaGridRow.DEFAULT_HEIGHT);
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.GROUP_KEY, meta.getGroupKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DETAIL_KEY, meta.getDetailKey(), "");
		DomHelper.writeAttr(element, MetaConstants.ROW_DEFAULTLAYER, meta.getDefaultLayer(),-1);
		DomHelper.writeAttr(element, MetaConstants.LINK_TYPE, SubDetailLinkType.toString(meta.getLinkType()), SubDetailLinkType.STR_Parent);
		DomHelper.writeAttr(element, MetaConstants.SOURCE_FIELDS, meta.getSource(), "");
		DomHelper.writeAttr(element, MetaConstants.TARGET_FIELDS, meta.getTarget(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FREEZE, meta.isFrozen(), false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEYWORDS, meta.getKeywords(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_REFKEY, meta.getRefKey(), "");
        DomHelper.writeAttr(element,  MetaConstants.COMMON_ROWTREEIMG, meta.getRowTreeImg(), "");
	}

}
