package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridFilter;

public class MetaGridFilterAction extends BaseDomAction<MetaGridFilter> {

	@Override
	public void load(Document document, Element element, MetaGridFilter meta, int runType) {
		
		meta.setOptSign(FilterOptSign.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_OP, FilterOptSign.STR_AND)));
		
		meta.setFilterDependency(DomHelper.readAttr(element, MetaConstants.GRID_FILTER_DEPENDENCY, ""));

		
	}

	@Override
	public void save(Document document, Element element, MetaGridFilter meta, int runType) {
		
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTER_OP, FilterOptSign.toString(meta.getOptSign()), FilterOptSign.STR_AND);
		
		DomHelper.writeAttr(element, MetaConstants.GRID_FILTER_DEPENDENCY, meta.getFilterDependency(), "");
		
	}

}
