package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.ProgressBarStyleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;

public class MetaProgressBarExtPropertiesAction extends DomPropertiesAction<MetaProgressBarProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaProgressBarProperties meta, int runType) {
		meta.setMaxPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MAXPOS, -1));
		meta.setMinPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MINPOS, -1));
		meta.setDynamic(DomHelper.readBool(element, MetaConstants.PROGRESSBAR_DYNAMIC, null));
		meta.setStepValue(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_STEPVALUE, -1));
		meta.setBarColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_BARCOLOR, null));
		meta.setProgressColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_PROGRESSCOLOR, null));
		meta.setStyle(ProgressBarStyleType.parse(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_STYLE, "")));
		meta.setRepeat(DomHelper.readBool(element, MetaConstants.PROGRESSBAR_REPEAT, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaProgressBarProperties meta, int runType) {
		
	}

}