package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;

public class MetaNumberEditorExtPropertiesAction extends DomPropertiesAction<MetaNumberEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaNumberEditorProperties meta, int runType) {
		meta.setPrecision(DomHelper.readInt(element, MetaConstants.NUMBEREDITOR_PRECISION, null));
		meta.setScale(DomHelper.readInt(element, MetaConstants.NUMBEREDITOR_SCALE, null));
		meta.setIntegerValue(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_INTEGERVALUE, null));
		meta.setUseGroupingSeparator(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR, null));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, null));
		meta.setSelectOnFocus(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_SELECTONFOCUS, null));
		meta.setRoundingMode(RoundingMode.parse(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_ROUNDINGMODE, "")));
		meta.setZeroString(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_ZEROSTRING, null));
		meta.setNegtiveForeColor(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_NEGTIVEFORECOLOR, null));
		meta.setShowZero(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_SHOWZERO, null));
		meta.setStripTrailingZeros(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_STRIPTRAILINGZEROS, null));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_DISABLEKEYBOARD, null));
		meta.setSuffix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, null));
		meta.setPrefix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, null));
		meta.setFormulaText(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_FORMULATEXT, null));
		meta.setAllowNull(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_ALLOWNULL, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaNumberEditorProperties meta, int runType) {
		
	}

}
