package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.def.ImageViewMode;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;

public class MetaImageExtPropertiesAction extends DomPropertiesAction<MetaImageProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaImageProperties meta, int runType) {
		meta.setSourceType(ImageSourceType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_SOURCETYPE, "")));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGE, null));
//		meta.setStretch(DomHelper.readBool(element, MetaConstants.PICTURE_STRETCH, null));
		meta.setMaxSize(DomHelper.readInt(element, MetaConstants.PICTURE_MAXSIZE, null));
		meta.setImageCut(DomHelper.readBool(element, MetaConstants.PICTURE_IMAGECUT, null));
		
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.PICTURE_PROMPTIMAGE, null));
		meta.setRadius(DomHelper.readAttr(element, MetaConstants.PICTURE_RADIUS, -1));
		meta.setFileName(DomHelper.readAttr(element, MetaConstants.PICTURE_FILENAME, null));
		meta.setViewMode(ImageViewMode.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_VIEWMODE, "")));
		meta.setViewOpt(DomHelper.readAttr(element, MetaConstants.PICTURE_VIEWOPT, false));
		meta.setMaskImage(DomHelper.readAttr(element, MetaConstants.PICTURE_MASKIMAGE, ""));
		meta.setShowThumbnail(DomHelper.readAttr(element, MetaConstants.PICTURE_SHOWTHUMBNAIL, true));
		meta.setUploadProgress(UploadProgressType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_UPLOADPROGRESS, "")));
		meta.setMaxShowSize(DomHelper.readInt(element, MetaConstants.PICTURE_MAXSHOWSIZE, -1));
		
	}

	@Override
	public void saveImpl(Document document, Element element, MetaImageProperties meta, int runType) {
		
	}

}
