package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DictFilterType;
import com.bokesoft.yigo.common.def.FilterOptSign;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaFilterExtAction extends BaseDomAction<MetaFilter> {


    @Override
    public void load(Document document, Element element, MetaFilter meta, int runType) {
        meta.setKey(DomHelper.readAttr(element,  MetaConstants.COMMON_KEY, ""));
        meta.setType(DictFilterType.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_TYPE, "")));
        meta.setExpression(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_EXPRESSION, null));
        meta.setQuery(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_QUERY, null));
        meta.setOp(FilterOptSign.parse(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_OP, "")));
        meta.setCondition(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_CONDITION, null));
        meta.setFilterDependency(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_DEPENDENCY, null));
        meta.setFilterCaption(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_CAPTION, null));
        meta.setImpl(DomHelper.readAttr(element, MetaConstants.DICT_FILTER_IMPL, null));
    }

    @Override
    public void save(Document document, Element element, MetaFilter meta, int runType) {

    }

}
