package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSeparatorProperties;

public class MetaSeparatorPropertiesAction extends DomPropertiesAction<MetaSeparatorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaSeparatorProperties meta, int runType) {
		int orientation = OrientationType.parse(
				DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.STR_Horizontal));
		meta.setOrientation(orientation);
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setIconLocaltion(IconLocationType
				.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_ICONLOCATION, IconLocationType.STR_LEFT)));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaSeparatorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ORIENTATION,
				OrientationType.toString(meta.getOrientation()), OrientationType.STR_Horizontal);
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ICONLOCATION,
				IconLocationType.toString(meta.getIconLocaltion()), IconLocationType.STR_LEFT);
	}
}
