package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ProgressBarStyleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;

public class MetaProgressBarPropertiesAction extends DomPropertiesAction<MetaProgressBarProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaProgressBarProperties meta, int runType) {
		meta.setMaxPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MAXPOS, MetaProgressBarProperties.DEFAULT_MAX_POS));
		meta.setMinPos(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_MINPOS, 0));
		meta.setDynamic(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_DYNAMIC, false));
		meta.setStepValue(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_STEPVALUE, MetaProgressBarProperties.DEFAULT_STEP_VALUE));
		meta.setBarColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_BARCOLOR, MetaProgressBarProperties.DEFAULT_BAR_COLOR));
		meta.setProgressColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_PROGRESSCOLOR, MetaProgressBarProperties.DEFAULT_PROGRESS_COLOR));
		meta.setStyle(ProgressBarStyleType.parse(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_STYLE, ProgressBarStyleType.STR_Horizontal)));
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.PROGRESSBAR_REPEAT, false));
	}
	
	@Override
	public void saveImpl(Document document, Element element, MetaProgressBarProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_MAXPOS, meta.getMaxPos(), MetaProgressBarProperties.DEFAULT_MAX_POS);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_MINPOS, meta.getMinPos(), 0);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_DYNAMIC, meta.isDynamic(), false);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue(), MetaProgressBarProperties.DEFAULT_STEP_VALUE);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor(), MetaProgressBarProperties.DEFAULT_BAR_COLOR);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor(), MetaProgressBarProperties.DEFAULT_PROGRESS_COLOR);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_STYLE, ProgressBarStyleType.toString(meta.getStyle()), ProgressBarStyleType.STR_Horizontal);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBAR_REPEAT, meta.isRepeat(), false);
	}
}
