package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;

public class MetaGIFImagePropertiesAction extends DomPropertiesAction<MetaGIFImageProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaGIFImageProperties meta, int runType) {
		meta.setSourceType(ImageSourceType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_SOURCETYPE, ImageSourceType.STR_DATA)));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGE, ""));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, "")));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaGIFImageProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PICTURE_SOURCETYPE, ImageSourceType.toString(meta.getSourceType()), ImageSourceType.STR_DATA);
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(element, MetaConstants.PICTURE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()), "");
	}

}
