package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFileChooserProperties;

public class MetaFileChooserPropertiesAction extends DomPropertiesAction<MetaFileChooserProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaFileChooserProperties meta, int runType) {
		meta.setUseType(DomHelper.readAttr(element, MetaConstants.FILECHOOSER_USETYPE, "Open"));
		meta.setAllowMulti(DomHelper.readAttr(element, MetaConstants.FILECHOOSER_ALLOWMULTI, false));
		meta.setExtFilter(DomHelper.readAttr(element, MetaConstants.FILECHOOSER_EXTFILTER, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaFileChooserProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.FILECHOOSER_USETYPE, meta.getUseType(), "Open");
		DomHelper.writeAttr(element, MetaConstants.FILECHOOSER_ALLOWMULTI, meta.isAllowMulti(), false);
		DomHelper.writeAttr(element, MetaConstants.FILECHOOSER_EXTFILTER, meta.getExtFilter(), "");
	}

}
