package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDateRangePickerProperties;

public class MetaDateRangePickerPropertiesAction extends DomPropertiesAction<MetaDateRangePickerProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaDateRangePickerProperties meta, int runType) {
		meta.setRangeSeparator(DomHelper.readAttr(element, MetaConstants.DATERANGEPICKER_RANGESEPARATOR, ""));
		meta.setStartPlaceholder(DomHelper.readAttr(element, MetaConstants.DATERANGEPICKER_STARTPLACEHOLDER, ""));
		meta.setEndPlaceholder(DomHelper.readAttr(element, MetaConstants.DATERANGEPICKER_ENDPLACEHOLDER, ""));
		meta.setDateFormat(DomHelper.readAttr(element, MetaConstants.DATERANGEPICKER_FORMAT, null));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.DATERANGEPICKER_PROMPTTEXT, ""));
	}
	
	@Override
	public void saveImpl(Document document, Element element, MetaDateRangePickerProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATERANGEPICKER_RANGESEPARATOR, meta.getRangeSeparator(), "");
		DomHelper.writeAttr(element, MetaConstants.DATERANGEPICKER_STARTPLACEHOLDER, meta.getStartPlaceholder(), "");
		DomHelper.writeAttr(element, MetaConstants.DATERANGEPICKER_ENDPLACEHOLDER, meta.getEndPlaceholder(), "");
		DomHelper.writeAttr(element, MetaConstants.DATERANGEPICKER_FORMAT, meta.getDateFormat(), null);
		DomHelper.writeAttr(element, MetaConstants.DATERANGEPICKER_PROMPTTEXT, meta.getPromptText(), "");
	}
}
