package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;

public class MetaDatePickerPropertiesAction extends DomPropertiesAction<MetaDatePickerProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaDatePickerProperties meta, int runType) {
		meta.setDateFormat(DomHelper.readAttr(element, MetaConstants.DATEPICKER_FORMAT, null));
		meta.setOnlyDate(DomHelper.readAttr(element, MetaConstants.DATEPICKER_ONLYDATE, false));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.DATEPICKER_PROMPTTEXT, ""));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.DATEPICKER_EDITTYPE, SelectEditType.STR_DIALOG)));
	}
	
	@Override
	public void saveImpl(Document document, Element element, MetaDatePickerProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_FORMAT, meta.getDateFormat(), null);
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_ONLYDATE, meta.isOnlyDate(), false);
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.DATEPICKER_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_DIALOG);
	}

}
