package com.bokesoft.yes.meta.persist.dom.form.component.control.gantt;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttTable;

public class MetaGanttTableAction extends BaseDomAction<MetaGanttTable> {

	@Override
	public void load(Document document, Element element, MetaGanttTable meta, int runType) {
		meta.setTableKey(DomHelper.readAttr(element, "TableKey", ""));
		meta.setDragProgress(DomHelper.readAttr(element, "DragProgress", false));
	}

	@Override
	public void save(Document document, Element element, MetaGanttTable meta, int runType) {
		DomHelper.writeAttr(element, "TableKey", meta.getTableKey(), "");
		DomHelper.writeAttr(element, "DragProgress", meta.getDragProgress(), false);
	}

}
