package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarItem;

public class MetaProgressBarItemAction extends BaseDomAction<MetaProgressBarItem>{

	@Override
	public void load(Document document, Element element, MetaProgressBarItem meta, int runType) {
		meta.setEndPos(DomHelper.readInt(element, MetaConstants.PROGRESSBARITEM_ENDPOS, 0));
		meta.setStartPos(DomHelper.readInt(element, MetaConstants.PROGRESSBARITEM_STARTPOS, 0));
		meta.setColor(DomHelper.readAttr(element, MetaConstants.PROGRESSBARITEM_COLOR, null));
	}

	@Override
	public void save(Document document, Element element, MetaProgressBarItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBARITEM_ENDPOS, meta.getEndPos(), 0);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBARITEM_STARTPOS, meta.getStartPos(), 0);
		DomHelper.writeAttr(element, MetaConstants.PROGRESSBARITEM_COLOR, meta.getColor(), null);
	}
	
}
