package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;

/**
 * 功能控件关联字段对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaDataBindingAction extends BaseDomAction<MetaDataBinding> {

	@Override
	public void load(Document document, Element element, MetaDataBinding meta, int runType) {
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setRequired(DomHelper.readAttr(element, MetaConstants.DATABINDING_REQUIRED, false));
		meta.setValueChanging(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUECHANGING, ""));
		meta.setValueChanged(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUECHANGED, ""));
		meta.setValueChangeAction(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUECHANGEACTION, ""));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTVALUE, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, ""));
		meta.setValueDependency(DomHelper.readAttr(element, MetaConstants.DATABINDING_VALUEDEPENDENCY, ""));
		meta.setCheckRule(DomHelper.readAttr(element, MetaConstants.DATABINDING_CHECKRULE, ""));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORINFO, ""));
		meta.setErrorStringID(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORSTRINGID, ""));
		meta.setCheckDependency(DomHelper.readAttr(element, MetaConstants.DATABINDING_CHECKDEPENDENCY, ""));
		meta.setRequiredIcon(DomHelper.readAttr(element, MetaConstants.COMMON_REQUIRED_ICON, ""));
		meta.setCheckRulePassIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_PASS_ICON, ""));
		meta.setCheckRuleErrorIcon(DomHelper.readAttr(element, MetaConstants.COMMON_CHECKRULE_ERROR_ICON, ""));
	}

	@Override
	public void save(Document document, Element element, MetaDataBinding meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_REQUIRED, meta.isRequired(), false);
		String valueChanging = "";
		if ( meta.getValueChangingNode() == null ) {
			valueChanging = meta.getValueChanging();
		}else {
			String content = meta.getValueChangingNode().getContent();
			if (content.length()<50 && content.indexOf("//")==-1&& convertCrLfByClientOS(content)){
				valueChanging = meta.getValueChangingNode().getContent();
				meta.setValueChangingNode(null);
			}
		}

		String valueChanged = "";
		if ( meta.getValueChangedNode() == null ) {
			valueChanged = meta.getValueChanged();
		}else {
			String content = meta.getValueChangedNode().getContent();
			if (content.length()<50 && content.indexOf("//")==-1&& convertCrLfByClientOS(content)){
				valueChanged = meta.getValueChangedNode().getContent();
				meta.setValueChangedNode(null);
			}
		}

		String valueChangedAction = "";
		if (meta.getValueChangeActionNode() == null) {
			valueChangedAction = meta.getValueChangeAction();
		} else {
			String content = meta.getValueChangeActionNode().getContent();
			if (content.length()<50 && content.indexOf("//")==-1&& convertCrLfByClientOS(content)){
				valueChangedAction = meta.getValueChangeActionNode().getContent();
				meta.setValueChangeActionNode(null);
			}
		}


		String defaultFormulaValue = "";
		if ( meta.getDefaultFormulaValueNode() == null ) {
			defaultFormulaValue = meta.getDefaultFormulaValue();
		}else {
			String content = meta.getDefaultFormulaValueNode().getContent();
			if (content.length()<50 && content.indexOf("//")==-1&& convertCrLfByClientOS(content)){
				defaultFormulaValue = meta.getDefaultFormulaValueNode().getContent();
				meta.setDefaultFormulaValueNode(null);
			}
		}

		String checkRule = "";
		if ( meta.getCheckRuleNode() == null  ) {
			checkRule = meta.getCheckRule();
		}else {
			String content = meta.getCheckRuleNode().getContent();
			if (content.length()<50 &&content.indexOf("//")==-1 && convertCrLfByClientOS(content)){
			     checkRule = meta.getCheckRuleNode().getContent();
			     meta.setCheckRuleNode(null);
			}
		}
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_VALUECHANGING, valueChanging, "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_VALUECHANGED, valueChanged, "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_VALUECHANGEACTION, valueChangedAction, "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_DEFAULTVALUE, meta.getDefaultValue(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, defaultFormulaValue, "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_VALUEDEPENDENCY, meta.getValueDependency(), "");
		
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_CHECKRULE, checkRule, "");
		DomHelper.writeAttr(element, MetaConstants.CHECKRULE_ERRORINFO, meta.getErrorInfo(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKRULE_ERRORSTRINGID, meta.getErrorStringID(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_CHECKDEPENDENCY, meta.getCheckDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_REQUIRED_ICON, meta.getRequiredIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECKRULE_PASS_ICON, meta.getCheckRulePassIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECKRULE_ERROR_ICON, meta.getCheckRuleErrorIcon(), "");
	}

	/**
	 * 根据操作系统类型判断内容中是否存在换行符
	 * @return
	 */
	private boolean convertCrLfByClientOS(String content) {
		String clientOS = System.getProperty("os.name", "");
		if (clientOS.contains("Windows")) {
			return  content.indexOf("\r\n") == -1 || content.indexOf("\n") == -1;
		} else if (clientOS.contains("Linux")) {
			return  content.indexOf("\n") == -1;
		} else if (clientOS.contains("Mac")) {
			return  content.indexOf("\r") == -1;
		}
		return  false;
	}

}
