package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.CarouselSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaCarousel;

public class MetaCarouselAction extends MetaComponentAction<MetaCarousel> {
	@Override
	public void load(Document document, Element element, MetaCarousel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setSourceType(CarouselSourceType.parse(DomHelper.readAttr(element, MetaConstants.CAROUSEL_SOURCETYPE, CarouselSourceType.STR_ITEMS)));
		meta.setAutoplay(DomHelper.readBool(element, MetaConstants.CAROUSEL_AUTOPLAY, Boolean.TRUE));
		meta.setInfinite(DomHelper.readBool(element, MetaConstants.CAROUSEL_INFINITE, Boolean.TRUE));
		meta.setAutoplayInterval(DomHelper.readAttr(element, MetaConstants.CAROUSEL_AUTOPLAYINTERVAL, -1));
		meta.setShowDots(DomHelper.readBool(element, MetaConstants.CAROUSEL_SHOWDOTS, Boolean.TRUE));
	}

	@Override
	public void save(Document document, Element element, MetaCarousel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.CAROUSEL_SOURCETYPE, CarouselSourceType.format(meta.getSourceType()), CarouselSourceType.STR_ITEMS);
		
		DomHelper.writeAttr(element, MetaConstants.CAROUSEL_AUTOPLAY, meta.isAutoplay(), Boolean.TRUE);
		DomHelper.writeAttr(element, MetaConstants.CAROUSEL_INFINITE, meta.isInfinite(), Boolean.TRUE);
		DomHelper.writeAttr(element, MetaConstants.CAROUSEL_AUTOPLAYINTERVAL, meta.getAutoplayInterval(), -1);
		DomHelper.writeAttr(element, MetaConstants.CAROUSEL_SHOWDOTS, meta.isShowDots(), Boolean.TRUE);

	}
}
