package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaTableSource;

public class MetaTableSourceAction extends BaseDomAction<MetaTableSource> {

	@Override
	public void load(Document document, Element element, MetaTableSource meta,
			int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDBTableName(DomHelper.readAttr(element, MetaConstants.TABLE_DBTABLENAME, ""));
		meta.setSourceType(TableSourceType.parse(DomHelper.readAttr(element, MetaConstants.TABLE_SOURCETYPE, TableSourceType.STR_TABLE_OLD)));
		meta.setRule(DomHelper.readAttr(element, MetaConstants.TABLE_RULE, ""));
		meta.setLinkTable(DomHelper.readAttr(element, MetaConstants.TABLE_LINKTABLE, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.TABLE_DESCRIPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.TABLE_IMPL, ""));
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.TABLE_FORMULA, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTableSource meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_DBTABLENAME, meta.getDBTableName(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_SOURCETYPE, TableSourceType.toString(meta.getSourceType()), TableSourceType.STR_TABLE_OLD);
		DomHelper.writeAttr(element, MetaConstants.TABLE_RULE, meta.getRule(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_LINKTABLE, meta.getLinkTable(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_FORMULA,meta.getFormula(),"");
	}

}
