package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.HistoryTarget;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaHistory;

public class MetaHistoryAction extends BaseDomAction<MetaHistory> {

	@Override
	public void load(Document document, Element element, MetaHistory meta,
			int runType) {
		meta.setSupport(DomHelper.readAttr(element, MetaConstants.HISTORY_SUPPORT, false));
		meta.setTarget(HistoryTarget.parse(DomHelper.readAttr(element, MetaConstants.HISTORY_TARGET, HistoryTarget.STR_DB)));
	}

	@Override
	public void save(Document document, Element element, MetaHistory meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.HISTORY_SUPPORT, meta.isSupport(), false);
		DomHelper.writeAttr(element, MetaConstants.HISTORY_TARGET, HistoryTarget.toString(meta.getTarget()), HistoryTarget.STR_DB);
	}

}
