package com.bokesoft.yes.meta.persist.dom.dataobject;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormExtendActionMap;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaForm;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.AbstractLoad;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;

/**
 * 数据对象的载入
 * 
 * @author 李姝
 * @since YES1.0
 */
public class MetaDataObjectLoad extends AbstractLoad {

	public MetaDataObjectLoad(int runType) {
		super(runType);
	}
	public boolean checkExtend(AbstractMetaObject meta,Object node) {

		String tagName = meta.getTagName();

		Element ele = (Element)node;

		if( tagName.endsWith(MetaDataObject.TAG_NAME) ) {
			String extend = DomHelper.readAttr(ele, MetaConstants.FORM_EXTEND, "");
			if( extend != null && !extend.isEmpty() ) {
				return true;
			}
		}
		return false;
	}
	@Override
	public AbstractMetaObject newRootMetaObject(Element root) {
		return new MetaDataObject();
	}

	@Override
	protected IMetaActionMap getActionMap() {
		return MetaDataObjectActionMap.getInstance();
	}
	@Override
	protected IMetaActionMap getExtendActionMap() {
		return MetaDataObjectExtendActionMap.getInstance();
	}

}
