package com.bokesoft.yes.meta.persist.dom.datamigration;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamigration.DMGroupingPolicyType;
import com.bokesoft.yigo.meta.datamigration.DMOpSign;
import com.bokesoft.yigo.meta.datamigration.DMPeriodGranularityType;
import com.bokesoft.yigo.meta.datamigration.DMPeriodValuePeekType;
import com.bokesoft.yigo.meta.datamigration.MetaDMConstants;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;

public class MetaDMSourceFieldAction extends BaseDomAction<MetaDMSourceField> {

	@Override
	public void load(Document document, Element element, MetaDMSourceField meta, int runType) {
		meta.setType(FieldType.parseType(DomHelper.readAttr(element, MetaDMConstants.TYPE, FieldType.STR_FIELD)));
		meta.setKey(DomHelper.readAttr(element, "Key", ""));
		meta.setDefinition(DomHelper.readAttr(element, MetaDMConstants.DEFINITION, ""));
		meta.setOpSign(DMOpSign.parse(DomHelper.readAttr(element, MetaDMConstants.OP_SIGN, DMOpSign.STR_OP_ADD_DELTA)));
		meta.setIsNegtive(DomHelper.readAttr(element, MetaDMConstants.ISNEGTIVE, false));
		meta.setGroupingPolicy(DMGroupingPolicyType.parse(DomHelper.readAttr(element, MetaDMConstants.GROUPING_POLICY, DMGroupingPolicyType.STR_Discrete)));
		meta.setPeriodValue(DMPeriodValuePeekType.parse(DomHelper.readAttr(element, MetaDMConstants.PERIOD_VALUE, DMPeriodValuePeekType.STR_Default)));
		meta.setTargetTableKey(DomHelper.readAttr(element, MetaDMConstants.TARGET_TABLE_KEY, ""));
		meta.setTargetFieldKey(DomHelper.readAttr(element, MetaDMConstants.TARGET_FIELD_KEY, ""));
		meta.setRefFieldKey(DomHelper.readAttr(element, MetaDMConstants.REF_FIELD_KEY, ""));
		meta.setDateGranularity(DMPeriodGranularityType.parse(DomHelper.readAttr(element, MetaDMConstants.DATE_GRANULARITY, "")));
	}

	@Override
	public void save(Document document, Element element, MetaDMSourceField meta, int runType) {
		DomHelper.writeAttr(element, MetaDMConstants.TYPE, FieldType.formatTypeString(meta.getType()), FieldType.STR_FIELD);
		DomHelper.writeAttr(element, MetaDMConstants.DEFINITION, meta.getDBDefinition(), "");
		DomHelper.writeAttr(element, "Key", meta.getKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.OP_SIGN, DMOpSign.toString(meta.getOpSign()), DMOpSign.STR_OP_ADD_DELTA);
		DomHelper.writeAttr(element, MetaDMConstants.ISNEGTIVE, meta.getIsNegtive(), false);
		DomHelper.writeAttr(element, MetaDMConstants.GROUPING_POLICY, DMGroupingPolicyType.toString(meta.getGroupingPolicy()), DMGroupingPolicyType.STR_Discrete);
		DomHelper.writeAttr(element, MetaDMConstants.PERIOD_VALUE, DMPeriodValuePeekType.toString(meta.getPeriodValue()), DMPeriodValuePeekType.STR_Default);
		DomHelper.writeAttr(element, MetaDMConstants.TARGET_TABLE_KEY, meta.getTargetTableKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.TARGET_FIELD_KEY, meta.getTargetFieldKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.REF_FIELD_KEY, meta.getRefFieldKey(), "");
		DomHelper.writeAttr(element, MetaDMConstants.DATE_GRANULARITY, DMPeriodGranularityType.toString(meta.getDateGranularity()), "");
	}
}
