package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.SearchBoxProviderType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaSearchBoxProvider;

public class MetaSearchBoxProviderAction extends BaseDomAction<MetaSearchBoxProvider> {

	@Override
	public void load(Document document, Element element, MetaSearchBoxProvider meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setType(SearchBoxProviderType.parse(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_TYPE, "")));
		meta.setDataObjectKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_DATAOBJECTKEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_COLUMNKEY, ""));
		meta.setSQL(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_SQL, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_IMPL, ""));
		meta.setPopConfigKey(DomHelper.readAttr(element, MetaConstants.SEARCHBOXPROVIDER_POPCONFIGKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSearchBoxProvider meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_TYPE, SearchBoxProviderType.toString(meta.getType()), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_DATAOBJECTKEY, meta.getDataObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_SQL, meta.getSQL(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.SEARCHBOXPROVIDER_POPCONFIGKEY, meta.getPopConfigKey(), "");
	}

}
