package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaExtend;

public class MetaExtendAction extends BaseDomAction<MetaExtend> {

	@Override
	public void load(Document document, Element element, MetaExtend meta, int runType) {
		meta.setClassName(DomHelper.readAttr(element, MetaConstants.EXTEND_CLASS, ""));
		meta.setAlias(DomHelper.readAttr(element, MetaConstants.EXTEND_ALIAS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExtend meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.EXTEND_CLASS, meta.getClassName(), "");
		DomHelper.writeAttr(element, MetaConstants.EXTEND_ALIAS, meta.getAlias(), "");
	}

}
