package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ScriptRunType;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaBaseScriptAction<T extends MetaBaseScript> extends BaseDomAction<T> {
	@Override
	public void load(Document document, Element element, T meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setTagName(element.getTagName().intern());
		meta.setType(ScriptType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_TYPE, ScriptType.STR_Formula)));
		meta.setRunType(ScriptRunType.parse(DomHelper.readAttr(element, MetaConstants.SCRIPT_RUNTYPE, ScriptRunType.STR_Undefined)));
		meta.setContent(DomHelper.readCDATAContent(element).trim().intern());
	}

	@Override
	public void save(Document document, Element element, T meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TYPE, ScriptType.toString(meta.getType()), ScriptType.STR_Formula);
		DomHelper.writeAttr(element, MetaConstants.SCRIPT_RUNTYPE, ScriptRunType.toString(meta.getRunType()), ScriptRunType.STR_Undefined);
		DomHelper.writeCDATAContent(document, element, meta.getContent());
	}

}
