package com.bokesoft.yes.meta.persist.dom.charging;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.charging.MetaChargingTargetObject;

public class MetaChargingTargetObjectAction extends BaseDomAction<MetaChargingTargetObject> {

	@Override
	public void load(Document document, Element element, MetaChargingTargetObject meta, int runType) {
		meta.setObjectKey(DomHelper.readAttr(element, MetaConstants.CHARGING_OBJECT_KEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.CHARGING_TABLE_KEY, ""));
		meta.setPolicy(MetaChargingTargetObject.parsePolicy(DomHelper.readAttr(element, MetaConstants.CHARGING_TARGET_POLICY, MetaChargingTargetObject.STR_UPDATE_FIRST)));
	}

	@Override
	public void save(Document document, Element element, MetaChargingTargetObject meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CHARGING_OBJECT_KEY, meta.getObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TABLE_KEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TARGET_POLICY, MetaChargingTargetObject.toPolicyString(meta.getPolicy()), MetaChargingTargetObject.STR_UPDATE_FIRST);
	}

}
