package com.bokesoft.yes.meta.persist.dom.businessdiagram.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.businessdiagram.MetaBusinessDiagramConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.businessdiagram.MetaBusinessDiagramLine;

public class MetaBusinessDiagramLineAction extends BaseDomAction<MetaBusinessDiagramLine> {

	@Override
	public void load(Document document, Element element,
			MetaBusinessDiagramLine meta, int runType) {
		meta.setID(DomHelper.readAttr(element, MetaBusinessDiagramConstants.ID, -1));
		meta.setKey(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Key, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Caption, ""));
		meta.setFromID(DomHelper.readAttr(element, MetaBusinessDiagramConstants.From, -1));
		meta.setToID(DomHelper.readAttr(element, MetaBusinessDiagramConstants.To, -1));
		meta.setType(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Type, ""));
		meta.setStatus(DomHelper.readAttr(element, MetaBusinessDiagramConstants.Status, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaBusinessDiagramLine meta, int runType) {
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.ID, meta.getID(), -1);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Key, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Caption, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.From, meta.getFromID(), -1);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.To, meta.getToID(), -1);
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Type, meta.getType(), "");
		DomHelper.writeAttr(element, MetaBusinessDiagramConstants.Status, meta.getStatus(), "");
	}
}
