package com.bokesoft.yes.meta.persist.dom.bpm.action.perm.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaProcessPerm;

public class MetaProcessPermAction extends BaseDomAction<MetaProcessPerm> {

	@Override
	public void load(Document document, Element element, MetaProcessPerm meta, int runType) {
		meta.setProcessKey(DomHelper.readAttr(element, BPMConstants.PERM_PROCESSKEY, ""));
		meta.setVersion(DomHelper.readAttr(element, BPMConstants.PERM_VERSION, -1));
	}
	
	@Override
	public void save(Document document, Element element, MetaProcessPerm meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.PERM_PROCESSKEY, meta.getProcessKey(), "");
		DomHelper.writeAttr(element, BPMConstants.PERM_VERSION, meta.getVersion(), -1);
	}
}
