package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiUserTask;

public class MetaMultiUserTaskAction extends MetaUserTaskAction<MetaMultiUserTask> {

	@Override
	public void load(Document doc, Element node, MetaMultiUserTask meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setInOrder(DomHelper.readAttr(node, BPMConstants.NODE_IN_ORDER, false));
	}

	@Override
	public void save(Document doc, Element node, MetaMultiUserTask meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_IN_ORDER, meta.isInOrder(), false);
	}
}
