package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;

public class MetaAuditAction< T extends MetaAudit> extends MetaUserTaskAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setDenyNodeKey(DomHelper.readAttr(node, BPMConstants.NODE_DENY_NODE_KEY, ""));
		meta.setDenyToLastNode(DomHelper.readAttr(node, BPMConstants.NODE_DENY_TO_LAST_NODE, false));
		meta.setDirectAudit(DomHelper.readAttr(node, BPMConstants.DIRECT_AUDIT, false));
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_DENY_NODE_KEY, meta.getDenyNodeKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_DENY_TO_LAST_NODE, meta.isDenyToLastNode(), false);
		DomHelper.writeAttr(node, BPMConstants.DIRECT_AUDIT, meta.isDirectAudit(), false);
	}

}
