package com.bokesoft.yes.meta.persist.dom.bpm.action.monitor;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.monitor.MetaLogger;

public class MetaLoggerAction extends BaseDomAction<MetaLogger> {

	@Override
	public void load(Document document, Element element, MetaLogger meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.MONITOR_KEY, ""));
		meta.setUseDefault(DomHelper.readAttr(element, BPMConstants.MONITOR_DEFAULT, false));
		meta.setProvider(DomHelper.readAttr(element, BPMConstants.MONITOR_PROVIDER, ""));
	}

	@Override
	public void save(Document document, Element element, MetaLogger meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.MONITOR_KEY, meta.getKey(),"");
		DomHelper.writeAttr(element, BPMConstants.MONITOR_DEFAULT, meta.isUseDefault(),false);
		DomHelper.writeAttr(element, BPMConstants.MONITOR_PROVIDER, meta.getProvider(),"");
	}

}
