package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerExternalLink;

public class MetaTimerExternalLinkAction extends BaseDomAction<MetaTimerExternalLink> {

	@Override
	public void load(Document document, Element element, MetaTimerExternalLink meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, BPMConstants.COMMON_KEY, ""));
		meta.setPeroid(DomHelper.readAttr(element, BPMConstants.TIMER_PEROID, ""));
		
	}
	
	@Override
	public void save(Document document, Element element, MetaTimerExternalLink meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, BPMConstants.TIMER_PEROID, meta.getPeroid(), "");
		
	}
}
