package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerAutoAbstain;

public class MetaTimerAutoAbstainAction extends BaseDomAction<MetaTimerAutoAbstain> {

	@Override
	public void load(Document doc, Element node, MetaTimerAutoAbstain meta, int runType) {
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setPeroid(DomHelper.readAttr(node, BPMConstants.TIMER_PEROID, ""));
		meta.setUserInfo(DomHelper.readAttr(node, BPMConstants.TIMER_USER_INFO, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaTimerAutoAbstain meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.TIMER_PEROID, meta.getPeroid(), "");
		DomHelper.writeAttr(node, BPMConstants.TIMER_USER_INFO, meta.getUserInfo(), "");
	}

}
