package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMElementAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;

public class MetaAssociationAction extends MetaBPMElementAction<MetaAssociation> {

	@Override
	public void load(Document doc, Element node, MetaAssociation meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setTargetNodeKey(DomHelper.readAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaAssociation meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY, meta.getTargetNodeKey(), "");
	}

}
