package com.bokesoft.yes.meta.persist.dom;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;

public abstract class AbstractSave implements IMetaEnv {

	protected Document document = null;

	/**
	 * 根数据对象
	 */
	protected AbstractMetaObject rootMetaObject = null;

	private IMetaActionMap actionMap = null;

	public AbstractSave(AbstractMetaObject rootMetaObject) {
		this.rootMetaObject = rootMetaObject;
		this.actionMap = this.getActionMap();
	}

	protected abstract IMetaActionMap getActionMap();
	
	protected void saveDocument(Document document, IMetaResolver resolver, String resource) throws Exception {
		//byte[] bytes = DomHelper.toBytes(document);
		//resolver.write(resource, bytes);
		saveXml(document, resolver, resource);
	}
	
	/**
	 * 将当前dom对象与源文件进行比较后保存， 保留源文件中的注释， 以及属性顺序
	 * @param document
	 * @param resolver
	 * @param resource
	 * @throws Exception
	 */
	private void saveXml(Document document, IMetaResolver resolver, String resource) throws Exception {
		XmlTree xmlTree = Xml4jUtil.parseTree(resource);
		XmlCreator creator = new XmlCreator(document, xmlTree);
		String xml = creator.createXml();
		byte[] bytes = xml.getBytes("UTF-8");
		resolver.write(resource, bytes);
	}
	
	public void save(IMetaResolver resolver, String resource) throws Exception {
		Document document = DomHelper.createDocument();
		saveToDocument(document);
		saveDocument(document, resolver, resource);
	}
	
	public Document getDocument() throws Exception {
		Document document = DomHelper.createDocument();
		saveToDocument(document);
		return document;
	}
	
	/**
	 * 保存数据对象
	 * 
	 * @throws MetaException
	 */
	public void saveToDocument(Document document) throws MetaException {
		this.saveToDocument(document, rootMetaObject);
		/*this.document = document;
		Element rootElement = document.createElement(rootMetaObject
				.getTagName());
		document.appendChild(rootElement);
		rootMetaObject.traversal(this, document, rootElement, true, AppRunType.Dev);*/
	}
	
	public void saveToDocument(Document document, AbstractMetaObject meta) {
		this.document = document;
		Element rootElement = document.createElement(meta.getTagName());
		document.appendChild(rootElement);
		meta.traversal(this, document, rootElement, true, AppRunType.Dev);
	}

	public Object prepare(AbstractMetaObject meta, Object node) {
		Element element = (Element) node;
		Element resultElement = null;
		// 如果是需要独立节点的元数据对象，则需要创建一个新节点
		if ( meta.isStandaloneNode() ) {
			resultElement = document.createElement(meta.getTagName());
			element.appendChild(resultElement);
		} else {
			// 否则使用当前节点
			resultElement = element;
		}

		return resultElement;
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(AbstractMetaObject meta, Object node) {
		IMetaAction<AbstractMetaObject> action = actionMap.getAction(meta.getTagName());
		if (action == null && node instanceof Element) {
			Element elem = (Element) node;
			Node parent = elem.getParentNode();
			if (parent != null) {
				action = actionMap.getAction(parent.getNodeName(), meta.getTagName());
			}
		}
		return action;
	}
	
	@Override
	public boolean checkExtend(AbstractMetaObject meta,Object node) {
		// TODO Auto-generated method stub
		return false;
	}

}
