package com.bokesoft.yes.meta.dataobject;

import java.util.ArrayList;
import java.util.Iterator;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.constants.RightsConstants;
import com.bokesoft.yigo.common.def.*;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumnCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;

/**
 * 表格创建者
 *
 * @author 刘翔翔
 */
public class SchemaCreator {

	/** 配置对象 */
	private MetaDataObject dataObject = null;

	public SchemaCreator(MetaDataObject dataObject) {
		this.dataObject = dataObject;
	}

	/***
	 * 获取主键迁移策略主表名
	 * @return
	 */
	public String getKeysMigrationMainTableName() {
		int secondaryType = dataObject.getSecondaryType();
		MetaTable mainTable = dataObject.getMainTable();
		if (mainTable == null) {
			return null;
		}
		// 迁移表并且是指定的更新策略
		if (secondaryType == DataObjectSecondaryType.MIGRATION
				&& dataObject.getMigrationUpdateStrategy() == MigrationUpdateStrategyType.KEYS_TABLE_FOCUS_CHANGE) {
			return mainTable.getBindingDBTableName();
		}
		return null;
	}

	/***
	 * 获取更新策略为主键表策略的数据对象
	 * @return MetaDataObject数据对象
	 */
	public MetaDataObject getKeysMigrationDataObject() {
		int secondaryType = dataObject.getSecondaryType();
		MetaTable mainTable = dataObject.getMainTable();
		if (mainTable == null) {
			return null;
		}
		// 迁移表并且是指定的更新策略
		if (secondaryType == DataObjectSecondaryType.MIGRATION
				&& dataObject.getMigrationUpdateStrategy() == MigrationUpdateStrategyType.KEYS_TABLE_FOCUS_CHANGE) {
			return dataObject;
		}
		return null;
	}

	public ArrayList<MetaSchemaTable> getSchemeTableList() {
		int secondaryType = dataObject.getSecondaryType();
		ArrayList<MetaSchemaTable> tableList = new ArrayList<MetaSchemaTable>();
		MetaTable mainTable = dataObject.getMainTable();

		// 迁移表的建表的特殊处理
		if (secondaryType == DataObjectSecondaryType.MIGRATION) {
			if (mainTable != null) {
				if (dataObject.getMigrationUpdateStrategy() != MigrationUpdateStrategyType.KEYS_TABLE_FOCUS_CHANGE) {
					tableList.add(newSchemeTable(mainTable, true, false, dataObject.isAutoGen()));
					MetaTable lpTable = dataObject.getMigrationLastPointTable();
					if (lpTable != null) {
						tableList.add(newSchemeTable(lpTable, true, false, dataObject.isAutoGen()));
					}
					//增量表不能作为迁移表处理，不能为分组字段创建唯一性索引
					MetaTable deltaTable = dataObject.getMigrationDeltaTable();
					if (deltaTable != null) {
						tableList.add(newSchemeTable(deltaTable, false, false, dataObject.isAutoGen()));
					}
				} else {
					// 主键表
					MetaTable keysTable = dataObject.getErpMigrationKeysTable();
					if (null != keysTable) {
						tableList.add(newSchemeTable(keysTable, true, false, dataObject.isAutoGen()));
					}
					// ERP增量表
					MetaTable incrTable = dataObject.getErpMigrationIncrTable();
					if (null != incrTable) {
						tableList.add(newSchemeTable(incrTable, false, false, dataObject.isAutoGen()));
					}
					// ERP主表新表
					MetaTable mainTableNewTable = dataObject.getErpMigrationNewTable();
					if (null != mainTableNewTable) {
						tableList.add(newSchemeTable(mainTableNewTable, false, false, dataObject.isAutoGen()));
					}
					// ERP LP表
					MetaTable lpTable = dataObject.getMigrationLastPointTable();
					if (lpTable != null) {
						tableList.add(newSchemeTable(lpTable, false, false, dataObject.isAutoGen()));
					}
					// newPre 分库附加
					MetaTable mainTableNewPreTable = dataObject.getErpMigrationNewPreTable();
					if (null != mainTableNewPreTable) {
						tableList.add(newSchemeTable(mainTableNewPreTable, false, false, dataObject.isAutoGen()));
					}
					// keysPre 分库附加
					MetaTable keysPreTable = dataObject.getErpMigrationKeysPreTable();
					if (null != keysPreTable) {
						tableList.add(newSchemeTable(keysPreTable, true, false, dataObject.isAutoGen()));
					}
				}
			}
			return tableList;
		}

		boolean hisTable = dataObject.getHistory() != null && dataObject.getHistory().isSupport();

		boolean uniqueSOID = secondaryType == DataObjectSecondaryType.NORMAL;
		for (MetaTable table : dataObject.getTableCollection()) {
			if (table.isPersist()) {
				tableList.add(newSchemeTable(table, false, uniqueSOID && table.isHead() && mainTable == table, dataObject.isAutoGen()));
				// 建立历史版本表
				if (hisTable)
					tableList.add(newHistoryTable(table));
			}
		}

		// 字典需要创建附属的权限表
		if (secondaryType == DataObjectSecondaryType.DICT || secondaryType == DataObjectSecondaryType.CHAINDICT) {
			MetaTable mainMetaTable = dataObject.getMainTable();
			if (mainMetaTable != null) {
				tableList.add(newRRTable(mainMetaTable));
				tableList.add(newORTable(mainMetaTable));
			}
		}
		return tableList;
	}

	public ArrayList<MetaSchemaTable> getDictSchemeTableList() {
		int secondaryType = dataObject.getSecondaryType();
		ArrayList<MetaSchemaTable> tableList = new ArrayList<MetaSchemaTable>();
		// 字典需要创建附属的权限表
		if (secondaryType == DataObjectSecondaryType.DICT || secondaryType == DataObjectSecondaryType.CHAINDICT) {
			MetaTable mainMetaTable = dataObject.getMainTable();
			if (mainMetaTable != null) {
				tableList.add(newRRTable(mainMetaTable));
				tableList.add(newORTable(mainMetaTable));
			}
		}
		return tableList;
	}

	static MetaSchemaTable newSchemeTable(MetaTable metaTable, boolean migration, boolean uniqueSOID, boolean autoGen) {
		MetaSchemaTable table = new MetaSchemaTable();
		table.setMigration(migration);
		table.setAutoGen(autoGen);
		table.setKey(metaTable.getBindingDBTableName());
		table.setPrimaryKey(metaTable.getPrimaryKey());
		table.setCaption(metaTable.getCaption());

		MetaSchemaColumnCollection columnCollection = table.getColumnCollection();
		MetaIndexCollection schemaIndexCollection = table.getIndexCollection();
		MetaIndexCollection indexCollection = metaTable.getIndexCollection();
		if (indexCollection != null && indexCollection.size() > 0)
			for (MetaIndex index : indexCollection)
				schemaIndexCollection.add(index);

		String indexPrefix = metaTable.getIndexPrefix4Create();

		ArrayList<String> migrationList = new ArrayList<String>();
		MetaSchemaColumn OIDColumn = null;
		boolean existPK = false;
		boolean existOIDPK = false;

		Iterator<MetaColumn> it = metaTable.iterator();
		while (it.hasNext()) {
			MetaColumn column = it.next();
			// 只有隐藏的列不做创建操作
			if (column.isHidden() || !column.isPersist())
				continue;

			MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
			schemaColumn.setKey(column.getBindingDBColumnName());
			schemaColumn.setCaption(column.getCaption());
			schemaColumn.setDataType(column.getDataType());
			schemaColumn.setPrecision(column.getPrecision());
			schemaColumn.setScale(column.getScale());
			schemaColumn.setLength(column.getLength());
			schemaColumn.setPK(column.isPrimaryKey());
			schemaColumn.setAutoGen(column.isAutoGen());
			schemaColumn.setDefaultValue(column.getDefaultValue());
			schemaColumn.setCaseSensitive(column.isCaseSensitive());

			if (column.isPrimaryKey())
				existPK = true;

			// 如果是OID列，设为主键
			if (SystemField.OID_SYS_KEY.equalsIgnoreCase(column.getKey())) {
				OIDColumn = schemaColumn;
				if (column.isPrimaryKey()) {
					existOIDPK = true;
				}
			}
			columnCollection.add(schemaColumn);

			if (column.isGroup())
				migrationList.add(column.getBindingDBColumnName());
		}

		if (!existPK && OIDColumn != null)
			OIDColumn.setPK(true);
		// 表中有OID字段，且主键字段配置中不存在OID时，需要增加OID字段唯一索引
		// WF相关的几个表是系统表，OID字段值不唯一，先用autoGen参数排除这些表
		if (!autoGen && !migration && existPK && !existOIDPK && OIDColumn != null) {
			MetaIndex index = new MetaIndex();
			index.setUnique(true);
			index.setKey(indexPrefix + "_OID");
			index.setColumns(OIDColumn.getKey());
			schemaIndexCollection.add(index);
		}
		// 为SOID，SrcOID，SrcSOID，建立非唯一索引
		MetaColumn SOID = metaTable.getSOIDColumn();
		if (!migration && SOID != null) {
			MetaIndex index = new MetaIndex();
			index.setUnique(uniqueSOID);
			index.setKey(indexPrefix + "_SOID");
			index.setColumns(SOID.getBindingDBColumnName());
			schemaIndexCollection.add(index);
		}
		MetaColumn SrcOID = metaTable.getSrcOIDColumn();
		if (SrcOID != null) {
			MetaIndex index = new MetaIndex();
			index.setKey(indexPrefix + "_SRCO");
			index.setColumns(SrcOID.getBindingDBColumnName());
			schemaIndexCollection.add(index);
		}
		MetaColumn SrcSOID = metaTable.getSrcSOIDColumn();
		if (SrcSOID != null) {
			MetaIndex index = new MetaIndex();
			index.setKey(indexPrefix + "_SRCS");
			index.setColumns(SrcSOID.getBindingDBColumnName());
			schemaIndexCollection.add(index);
		}
		MetaColumn Code = metaTable.getCODE();
		if (Code != null
				&& (StringUtil.isBlankOrNull(Code.getDBColumnName()) || Code.getKey().equalsIgnoreCase(Code.getDBColumnName()))
				&& metaTable.getSourceType() == TableSourceType.DATAOBJECT
				&& metaTable.getTableMode() == TableMode.HEAD) {
			MetaIndex index = new MetaIndex();
			index.setUnique(true);
			index.setKey(indexPrefix + "_CODE");
			index.setColumns(Code.getBindingDBColumnName());
			schemaIndexCollection.add(index);
		}
		MetaColumn SrcLangOID = metaTable.getSrcLangOID();
		if (SrcLangOID != null && metaTable.getKey().endsWith("_T")) {
			MetaIndex index = new MetaIndex();
			index.setUnique(false);
			index.setKey(indexPrefix + "_SrcLangOID");
			index.setColumns(SrcLangOID.getBindingDBColumnName());
			schemaIndexCollection.add(index);
		}

		// 为迁移添加查询索引
		if (migration) {
			if (migrationList.isEmpty()) {
				throw new MetaException(MetaException.MIGRATION_GROUP_NOT_DEFINED, SimpleStringFormat.format(
						StringTable.getString(null, "", StringTable.MigrationGroupNotDefined), metaTable.getKey()));
			}
			MetaIndex index = new MetaIndex();
			index.setKey(indexPrefix + "_MIGR");
			StringBuffer sb = new StringBuffer(migrationList.get(0));
			if (migrationList.size() > BalanceGroupField.MYSQL_INDEX_MAX_LENGTH) {
				for (int i = 1; i < BalanceGroupField.MYSQL_INDEX_MAX_LENGTH - 1 ; i++) {
					sb.append(",").append(migrationList.get(i));
				}
				sb.append(",").append(BalanceGroupField.GROUP_COUNT_FIELD);
			} else {
				for (int i = 1; i < migrationList.size(); i++) {
					sb.append(",");
					sb.append(migrationList.get(i));
				}
			}
			index.setColumns(sb.toString());
			index.setUnique(true);
			schemaIndexCollection.add(index);
		}

		// 增加锁定字段
		MetaSchemaColumn slockColumn = new MetaSchemaColumn();
		slockColumn.setKey(SystemField.SLOCK_SYS_KEY);
		slockColumn.setDataType(DataType.INT);
		columnCollection.add(slockColumn);

		return table;
	}

	/**
	 * 生成历史记录表(删除VERID列,增加HVER列)
	 *
	 * @param metaTable
	 *            表配置对象
	 * @return 数据库表结构
	 */
	static MetaSchemaTable newHistoryTable(MetaTable metaTable) {
		MetaSchemaTable table = new MetaSchemaTable();

		table.setKey(metaTable.getHistoryTableName());

		String primaryKey = metaTable.getPrimaryKey();
		if (primaryKey != null && !primaryKey.isEmpty()) {
			table.setPrimaryKey(primaryKey + "_HIS");
		}
		table.setCaption(metaTable.getCaption());

		MetaSchemaColumnCollection columnCollection = table.getColumnCollection();
		MetaIndexCollection indexCollection = table.getIndexCollection();

		// String tableKey = table.getKey();
		// int length = tableKey.length();
		// String indexPrefix = length > 15 ? tableKey.substring(length - 15) :
		// tableKey;
		String indexPrefix = metaTable.getIndexPrefix4Create();
		Iterator<MetaColumn> it = metaTable.iterator();
		while (it.hasNext()) {
			MetaColumn column = it.next();
			if (SystemField.VERID_SYS_KEY.equalsIgnoreCase(column.getDBColumnName()))
				continue;
			MetaSchemaColumn schemaColumn = new MetaSchemaColumn();
			schemaColumn.setKey(column.getBindingDBColumnName());
			schemaColumn.setCaption(column.getCaption());
			schemaColumn.setDataType(column.getDataType());
			schemaColumn.setPrecision(column.getPrecision());
			schemaColumn.setScale(column.getScale());
			schemaColumn.setLength(column.getLength());
			schemaColumn.setAutoGen(column.isAutoGen());
			columnCollection.add(schemaColumn);
		}

		// 增加锁定字段
		MetaSchemaColumn slockColumn = new MetaSchemaColumn();
		slockColumn.setKey(SystemField.SLOCK_SYS_KEY);
		slockColumn.setDataType(DataType.INT);
		columnCollection.add(slockColumn);

		// 增加版本字段
		MetaSchemaColumn verColumn = new MetaSchemaColumn();
		verColumn.setKey(SystemField.HVER_SYS_KEY);
		verColumn.setDataType(DataType.INT);
		columnCollection.add(verColumn);

		MetaSchemaColumn verColumn4m = new MetaSchemaColumn();
		verColumn4m.setKey(SystemField.HVERM_SYS_KEY);
		verColumn4m.setDataType(DataType.INT);
		columnCollection.add(verColumn4m);

		// 非唯一联合索引
		MetaColumn SOIDColumn = metaTable.getSOIDColumn();
		if (SOIDColumn != null) {
			MetaIndex index = new MetaIndex();
			index.setKey(indexPrefix + "HIS_SOID_HVER");
			index.setColumns(SOIDColumn.getBindingDBColumnName() + "," + "HVER");
			indexCollection.add(index);
		}

		return table;
	}

	/**
	 * 为字典的主表生成对应的角色权限表
	 *
	 * @param metaTable
	 * @return
	 */
	static MetaSchemaTable newRRTable(MetaTable metaTable) {
		String rrTableName = metaTable.getBindingDBTableName() + RightsConstants.RIGHTS_RR;

		MetaSchemaTable rrTable = new MetaSchemaTable();
		rrTable.setKey(rrTableName);
		String primaryKey = metaTable.getPrimaryKey();
		if (primaryKey != null && !primaryKey.isEmpty()) {
			rrTable.setPrimaryKey(primaryKey + RightsConstants.RIGHTS_RR);
		}

		MetaSchemaColumnCollection rrColumnCollection = new MetaSchemaColumnCollection();
		rrTable.setColumnCollection(rrColumnCollection);

		MetaSchemaColumn column = new MetaSchemaColumn();
		column.setKey("RoleID");
		column.setDataType(DataType.LONG);
		column.setPK(true);

		rrColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("FormKey");
		column.setDataType(DataType.STRING);
		column.setLength(128);
		rrColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("DictID");
		column.setDataType(DataType.LONG);
		column.setPK(true);
		rrColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasRights");
		column.setDataType(DataType.INT);
		rrColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasRead");
		column.setDataType(DataType.INT);
		rrColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasWrite");
		column.setDataType(DataType.INT);
		rrColumnCollection.add(column);
		return rrTable;
	}

	/**
	 * 为字典的主表生成对应的操作员权限表
	 *
	 * @param metaTable
	 * @return
	 */
	static MetaSchemaTable newORTable(MetaTable metaTable) {
		String orTableName = metaTable.getBindingDBTableName() + RightsConstants.RIGHTS_OR;

		MetaSchemaTable orTable = new MetaSchemaTable();
		orTable.setKey(orTableName);
		String primaryKey = metaTable.getPrimaryKey();
		if (primaryKey != null && !primaryKey.isEmpty()) {
			orTable.setPrimaryKey(primaryKey + RightsConstants.RIGHTS_OR);
		}

		MetaSchemaColumnCollection orColumnCollection = new MetaSchemaColumnCollection();
		orTable.setColumnCollection(orColumnCollection);

		MetaSchemaColumn column = new MetaSchemaColumn();
		column.setKey("OperatorID");
		column.setDataType(DataType.LONG);
		column.setPK(true);
		orColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("FormKey");
		column.setDataType(DataType.STRING);
		column.setLength(128);
		orColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("DictID");
		column.setDataType(DataType.LONG);
		column.setPK(true);
		orColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasRights");
		column.setDataType(DataType.INT);
		orColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasRead");
		column.setDataType(DataType.INT);
		orColumnCollection.add(column);

		column = new MetaSchemaColumn();
		column.setKey("HasWrite");
		column.setDataType(DataType.INT);
		orColumnCollection.add(column);
		return orTable;
	}

	public MetaSchemaTable getFormRightsTable() {
		if (dataObject == null)
			return null;

		MetaTable mainTable = dataObject.getMainTable();
		if (mainTable == null)
			return null;

		String frTableKey = mainTable.getBindingDBTableName() + RightsConstants.RIGHTS_FR;

		MetaSchemaTable frTable = new MetaSchemaTable();
		frTable.setKey(frTableKey);

		MetaSchemaColumnCollection columnCollection = new MetaSchemaColumnCollection();
		frTable.setColumnCollection(columnCollection);

		MetaSchemaColumn column = new MetaSchemaColumn();
		column.setKey("OID");
		column.setDataType(DataType.LONG);
		column.setPK(true);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("SOID");
		column.setDataType(DataType.LONG);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("OperatorID");
		column.setDataType(DataType.LONG);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("OptRights");
		column.setDataType(DataType.TEXT);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("Enables");
		column.setDataType(DataType.TEXT);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("unVisible");
		column.setDataType(DataType.TEXT);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		column = new MetaSchemaColumn();
		column.setKey("RightsSite");
		column.setDataType(DataType.TEXT);
		columnCollection.add(column);
		column.setAutoGen(dataObject.isAutoGen());

		return frTable;
	}
}
