package com.bokesoft.yes.meta.datamigration.calculate;

import com.bokesoft.yigo.meta.common.MetaMigrationExtension;
import com.bokesoft.yigo.meta.common.MetaMigrationExtensionCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MigrationExtensionUtil {
	/**
	 * 在指定数据对象的条件下，寻找迁移扩展属性
	 * 
	 * @param metaFactory
	 * @param dataObject
	 * @param name
	 * @return
	 * @throws Throwable
	 */
	public static MetaMigrationExtension findMigrationExtension(IMetaFactory metaFactory, MetaDataObject dataObject,
			String name) throws Throwable {
		MetaMigrationExtensionCollection migrationExtensionCollection = null;
		MetaMigrationExtension MigrationExtension = null;

		MetaProject metaProject = (MetaProject) dataObject.getProject();
		MetaCommonDef metaCommonDef = metaFactory.getCommonDef(metaProject.getKey());
		if (metaCommonDef != null) {
			metaCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey());
			if (metaCommonDef != null) {
				migrationExtensionCollection = metaCommonDef.getMigrationExtensionCollection();
				if (migrationExtensionCollection != null) {
					MigrationExtension = migrationExtensionCollection.get(name);
				}
			}
		}
		if (MigrationExtension == null) {
			metaCommonDef = metaFactory.getSolutionCommondDef(metaProject.getKey());
			if (metaCommonDef != null) {
				migrationExtensionCollection = metaCommonDef.getMigrationExtensionCollection();
				if (migrationExtensionCollection != null) {
					MigrationExtension = migrationExtensionCollection.get(name);
				}
			}
		}

		if (MigrationExtension == null) {
			metaCommonDef = metaFactory.getCommonDef("");
			if (metaCommonDef != null) {
				migrationExtensionCollection = metaCommonDef.getMigrationExtensionCollection();
				if (migrationExtensionCollection != null) {
					MigrationExtension = migrationExtensionCollection.get(name);
				}
			}
		}

		return MigrationExtension;
	}
}
